package gov.va.vinci.dart.common;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SingletonShim {
	private static final ApplicationContext ctx = new ClassPathXmlApplicationContext("classpath*:**/applicationContext.xml");
	private static final BeanFactory beanFactory=ctx;
	
	public static <T> T getBean(Class<T> requiredType) {
		return beanFactory.getBean(requiredType);
	}
}
